/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.mapui;

import filenet.vw.toolkit.utils.mapui.IVWRouteRender;
import filenet.vw.toolkit.utils.mapui.VWBaseRouteUI;
import filenet.vw.toolkit.utils.mapui.VWStepRouteColors;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

class VWRouteArcRender
implements IVWRouteRender {
    private int[] m_arrowXPts = new int[3];
    private int[] m_arrowYPts = new int[3];
    Rectangle m_routeRect = null;
    private Point m_routeCenter = new Point();
    private double m_routeAngle = 0.0;
    private double m_arcRadius = 0.0;
    private double m_arcAngle = 0.0;
    private double m_arcCenterX = 0.0;
    private double m_arcCenterY = 0.0;
    private double m_angleInc = 0.0;
    private double m_arcAngleBegin = 0.0;
    private double m_arcAngleEnd = 0.0;
    private Point m_endPt = null;
    private Point m_srcPt = null;
    private VWBaseRouteUI m_route = null;
    private VWStepRouteColors m_stepRouteColors = null;

    protected VWRouteArcRender(VWBaseRouteUI route) {
        this.m_route = route;
        if (this.m_route != null) {
            this.m_stepRouteColors = this.m_route.getStepRouteColors();
        }
    }

    public boolean contains(Point loc) {
        boolean bRetVal = false;
        double DELTA = 10.0;
        if (!this.m_routeRect.contains(loc.x, loc.y)) {
            return false;
        }
        double dx = (double)loc.x - this.m_arcCenterX;
        double dy = (double)loc.y - this.m_arcCenterY;
        double dist = Math.sqrt(dx * dx + dy * dy) - this.m_arcRadius;
        if (dist < DELTA && dist > -DELTA) {
            double angle = Math.atan2(dy, dx);
            if (angle < this.m_arcAngleBegin) {
                angle += Math.PI * 2;
            }
            if (angle <= this.m_arcAngleEnd) {
                bRetVal = true;
            }
        }
        return bRetVal;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.m_routeRect);
    }

    public void calcCoords() {
        double angle;
        this.calcEndPoints();
        double dx = this.m_endPt.x - this.m_srcPt.x;
        double dy = this.m_endPt.y - this.m_srcPt.y;
        double dist = Math.sqrt(dx * dx + dy * dy);
        double h = dist / 4.85;
        double a = dist / 2.0;
        double b = a * a / (2.0 * h) - h / 2.0;
        this.m_arcRadius = h + b;
        this.m_arcAngle = 2.0 * Math.atan2(b, a);
        this.m_arcAngle = this.normalizeAngle(this.m_arcAngle);
        double increments = Math.round(this.m_arcRadius * this.m_arcAngle);
        this.m_angleInc = this.m_arcAngle / increments;
        double beta = -1.5707963267948966 + this.m_routeAngle + this.m_arcAngle / 2.0;
        this.m_arcCenterX = (double)this.m_endPt.x - this.m_arcRadius * Math.cos(beta);
        this.m_arcCenterY = (double)this.m_endPt.y - this.m_arcRadius * Math.sin(beta);
        this.m_routeRect = this.createNormalizeRect(this.m_srcPt, this.m_endPt);
        this.m_arcAngleBegin = -1.5707963267948966 + this.m_routeAngle - this.m_arcAngle / 2.0;
        this.m_arcAngleEnd = -1.5707963267948966 + this.m_routeAngle + this.m_arcAngle / 2.0;
        for (double theta = -this.m_arcAngle / 2.0; theta <= this.m_arcAngle / 2.0; theta += this.m_angleInc) {
            angle = theta - 1.5707963267948966 + this.m_routeAngle;
            int x = (int)Math.round(this.m_arcCenterX + this.m_arcRadius * Math.cos(angle));
            int y = (int)Math.round(this.m_arcCenterY + this.m_arcRadius * Math.sin(angle));
            if (x < this.m_routeRect.x) {
                this.m_routeRect.x = x;
            } else if (x > this.m_routeRect.x + this.m_routeRect.width) {
                this.m_routeRect.width = x - this.m_routeRect.x;
            }
            if (y < this.m_routeRect.y) {
                this.m_routeRect.y = y;
                continue;
            }
            if (y <= this.m_routeRect.y + this.m_routeRect.height) continue;
            this.m_routeRect.height = y - this.m_routeRect.y;
        }
        angle = (this.m_arcAngleBegin + this.m_arcAngleEnd) / 2.0;
        this.m_routeCenter.x = (int)Math.round(this.m_arcCenterX + this.m_arcRadius * Math.cos(angle));
        this.m_routeCenter.y = (int)Math.round(this.m_arcCenterY + this.m_arcRadius * Math.sin(angle));
        --this.m_routeRect.x;
        this.m_routeRect.width += 2;
        --this.m_routeRect.y;
        this.m_routeRect.height += 2;
        this.m_arcAngleBegin = this.normalizeAngle(this.m_arcAngleBegin);
        this.m_arcAngleEnd = this.normalizeAngle(this.m_arcAngleEnd);
        if (this.m_arcAngleEnd < this.m_arcAngleBegin) {
            this.m_arcAngleEnd += Math.PI * 2;
        }
        this.createArrowHead();
    }

    private void createArrowHead() {
        double height = 14.0;
        double width = 12.0;
        double angle = this.m_routeAngle + this.m_arcAngle / 2.0;
        double r = Math.sqrt(193.0);
        double theta = Math.atan2(7.0, 12.0);
        this.m_arrowXPts[0] = this.m_endPt.x;
        this.m_arrowYPts[0] = this.m_endPt.y;
        this.m_arrowXPts[1] = (int)Math.round((double)this.m_endPt.x + r * Math.cos(angle + Math.PI + theta));
        this.m_arrowYPts[1] = (int)Math.round((double)this.m_endPt.y + r * Math.sin(angle + Math.PI + theta));
        this.m_arrowXPts[2] = (int)Math.round((double)this.m_endPt.x + r * Math.cos(angle + Math.PI - theta));
        this.m_arrowYPts[2] = (int)Math.round((double)this.m_endPt.y + r * Math.sin(angle + Math.PI - theta));
    }

    private void calcEndPoints() {
        double angle;
        Point destLoc = this.m_route.m_destStep.getImageCenterLocation();
        this.m_srcPt = this.m_route.m_srcStep.getImageCenterLocation();
        double horz = destLoc.x - this.m_srcPt.x;
        double vert = destLoc.y - this.m_srcPt.y;
        if (horz != 0.0) {
            angle = Math.atan(vert / horz);
            if (horz < 0.0) {
                angle = vert > 0.0 ? Math.PI + angle : -Math.PI + angle;
            }
        } else {
            angle = vert > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        double reverseAngle = angle == 0.0 ? Math.PI : (angle > 0.0 ? angle - Math.PI : Math.PI + angle);
        this.m_endPt = this.m_route.m_destStep.getBoundaryPoint(reverseAngle, true);
        this.m_routeAngle = Math.atan2(this.m_endPt.y - this.m_srcPt.y, this.m_endPt.x - this.m_srcPt.x);
        if (this.m_routeAngle < 0.0) {
            this.m_routeAngle += Math.PI * 2;
        }
    }

    public void paintComponent(Graphics g) {
        if (!this.m_route.m_srcStep.contains(this.m_endPt)) {
            Point prevPoint = new Point();
            Point point = new Point();
            prevPoint.x = (int)Math.round(this.m_arcCenterX + this.m_arcRadius * Math.cos(this.m_arcAngleBegin));
            prevPoint.y = (int)Math.round(this.m_arcCenterY + this.m_arcRadius * Math.sin(this.m_arcAngleBegin));
            Color curColor = g.getColor();
            if (this.m_route.getFocus()) {
                g.setColor(this.m_stepRouteColors.getFocusColor());
            } else if (this.m_route.getSelect()) {
                g.setColor(this.m_stepRouteColors.getSelectionColor());
            } else {
                g.setColor(this.m_stepRouteColors.getDefaultColor());
            }
            for (double angle = this.m_arcAngleBegin + this.m_angleInc; angle <= this.m_arcAngleEnd; angle += this.m_angleInc) {
                point.x = (int)Math.round(this.m_arcCenterX + this.m_arcRadius * Math.cos(angle));
                point.y = (int)Math.round(this.m_arcCenterY + this.m_arcRadius * Math.sin(angle));
                if (!this.m_route.m_srcStep.contains(prevPoint)) {
                    g.drawLine(prevPoint.x, prevPoint.y, point.x, point.y);
                }
                prevPoint.x = point.x;
                prevPoint.y = point.y;
            }
            g.fillPolygon(this.m_arrowXPts, this.m_arrowYPts, 3);
            g.setColor(curColor);
        }
    }

    public void printComponent(Graphics2D g2, int pageX, int pageY) {
        if (!this.m_route.m_srcStep.contains(this.m_endPt)) {
            int idx;
            Point prevPoint = new Point();
            Point point = new Point();
            prevPoint.x = (int)Math.round(this.m_arcCenterX - (double)pageX + this.m_arcRadius * Math.cos(this.m_arcAngleBegin));
            prevPoint.y = (int)Math.round(this.m_arcCenterY - (double)pageY + this.m_arcRadius * Math.sin(this.m_arcAngleBegin));
            Color curColor = g2.getColor();
            g2.setColor(Color.black);
            for (double angle = this.m_arcAngleBegin + this.m_angleInc; angle <= this.m_arcAngleEnd; angle += this.m_angleInc) {
                point.x = (int)Math.round(this.m_arcCenterX - (double)pageX + this.m_arcRadius * Math.cos(angle));
                point.y = (int)Math.round(this.m_arcCenterY - (double)pageY + this.m_arcRadius * Math.sin(angle));
                g2.drawLine(prevPoint.x, prevPoint.y, point.x, point.y);
                prevPoint.x = point.x;
                prevPoint.y = point.y;
            }
            int[] arrowX = new int[3];
            int[] arrowY = new int[3];
            for (idx = 0; idx < 3; ++idx) {
                arrowX[idx] = this.m_arrowXPts[idx] - pageX;
            }
            for (idx = 0; idx < 3; ++idx) {
                arrowY[idx] = this.m_arrowYPts[idx] - pageY;
            }
            g2.fillPolygon(arrowX, arrowY, 3);
            g2.setColor(curColor);
        }
    }

    private double normalizeAngle(double angle) {
        while (angle < -Math.PI) {
            angle += Math.PI * 2;
        }
        while (angle > Math.PI) {
            angle -= Math.PI * 2;
        }
        return angle;
    }

    private Rectangle createNormalizeRect(Point pt1, Point pt2) {
        Rectangle rect = new Rectangle();
        if (pt1.x <= pt2.x) {
            rect.x = pt1.x;
            rect.width = pt2.x - pt1.x;
        } else {
            rect.x = pt2.x;
            rect.width = pt1.x - pt2.x;
        }
        if (pt1.y <= pt2.y) {
            rect.y = pt1.y;
            rect.height = pt2.y - pt1.y;
        } else {
            rect.y = pt2.y;
            rect.height = pt1.y - pt2.y;
        }
        return rect;
    }

    public Point getPoint(double dist) {
        double angle = Math.asin(dist / (this.m_arcRadius * 2.0)) * 2.0;
        if (angle > this.m_arcAngleEnd - this.m_arcAngleBegin) {
            return null;
        }
        Point pt = new Point();
        pt.x = (int)Math.round(this.m_arcCenterX + this.m_arcRadius * Math.cos(angle + this.m_arcAngleBegin));
        pt.y = (int)Math.round(this.m_arcCenterY + this.m_arcRadius * Math.sin(angle + this.m_arcAngleBegin));
        return pt;
    }

    public Point getPoint(int percent) {
        if (percent < 0 || percent > 100) {
            return null;
        }
        double angle = (this.m_arcAngleEnd - this.m_arcAngleBegin) * (double)percent / 100.0;
        Point pt = new Point();
        pt.x = (int)Math.round(this.m_arcCenterX + this.m_arcRadius * Math.cos(angle + this.m_arcAngleBegin));
        pt.y = (int)Math.round(this.m_arcCenterY + this.m_arcRadius * Math.sin(angle + this.m_arcAngleBegin));
        return pt;
    }

    public Point getCenterPoint() {
        Point pt = new Point();
        pt.x = (int)Math.round(this.m_arcCenterX + this.m_arcRadius * Math.cos(this.m_arcAngleBegin + (this.m_arcAngleEnd - this.m_arcAngleBegin) / 2.0));
        pt.y = (int)Math.round(this.m_arcCenterY + this.m_arcRadius * Math.sin(this.m_arcAngleBegin + (this.m_arcAngleEnd - this.m_arcAngleBegin) / 2.0));
        return pt;
    }
}

